//====================================================
// Batch Rendering using Vector Constant Arrays
// Diffuse + Directional Light
// By: Jesse George (revenant_chaos@yahoo.com)
//====================================================


//--------------
// un-tweaks
//--------------
   matrix ViewProj:ViewProjection; 
   float4 World_R1[80];
   float4 World_R2[80];
   float4 World_R3[80];



//--------------
// tweaks
//--------------
   float3 Ambient={0.2f,0.2f,0.2f};
   float3 LightDir={0.5f,-0.5f,-0.5f};
   float3 LightColor={1.0f,1.0f,1.0f};



//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
   {
      texture = <BaseTX>;
      mipfilter = anisotropic;
      minfilter = anisotropic;
      magfilter = anisotropic;
   };



//--------------
// structs 
//--------------
   struct input
   {
      float4 Pos:POSITION; 
      float2 UV:TEXCOORD0; 
      float3 Normal:NORMAL;
      float ArrIndex:PSize;
   };
   struct output
   {
      float4 OPos:POSITION; 
      float2 Tex:TEXCOORD0; 
      float3 WNormal:TEXCOORD1;
   };



//--------------
// vertex shader
//--------------
   output VS(input IN) 
   {
      output OUT;

      //construct world matrix from array data
      int index = IN.ArrIndex;
      matrix wMat = transpose(float4x4(World_R1[index],
				       World_R2[index], 
				       World_R3[index], 
				       0.0f,0.0f,0.0f,1.0f));

      OUT.OPos=mul(mul(IN.Pos,wMat),ViewProj); 
      OUT.Tex=IN.UV;
      OUT.WNormal=normalize(mul(IN.Normal,(float3x3)wMat));

      return OUT;
   }



//--------------
// pixel shader
//--------------
   float4 PS(output IN)  : COLOR
   {
      float4 Texture=tex2D(Base,IN.Tex); 
      float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));
      return Texture*float4(Light+Ambient,1.0f);
   }



//--------------
// techniques   
//--------------
   technique Diffuse
   {
      pass p1
      {		
         vertexShader = compile vs_2_0 VS(); 
         pixelShader  = compile ps_2_0 PS();
      }
   }